Shader "Hidden/Noise Shader YUV" {
Properties {
	_MainTex ("Base (RGB)", RECT) = "white" {}
	_GrainTex ("Base (RGB)", 2D) = "gray" {}
	_ScratchTex ("Base (RGB)", 2D) = "gray" {}
}

SubShader {
	Pass {
		ZTest Always Cull Off ZWrite Off
		Fog { Mode off }
				
CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma fragmentoption ARB_precision_hint_fastest
#include "UnityCG.cginc"

struct v2f { 
	float4 pos	: POSITION;
	float2 uv	: TEXCOORD0;
	float2 uvg	: TEXCOORD1; // grain
	float2 uvs	: TEXCOORD2; // scratch
}; 

uniform samplerRECT _MainTex;
uniform sampler2D _GrainTex;
uniform sampler2D _ScratchTex;

uniform float4 _GrainOffsetScale;
uniform float4 _ScratchOffsetScale;
uniform float4 _Intensity; // x=grain, y=scratch

v2f vert (appdata_img v)
{
	v2f o;
	o.pos = mul (glstate.matrix.mvp, v.vertex);
	o.uv = MultiplyUV (glstate.matrix.texture[0], v.texcoord);
	o.uvg = v.texcoord.xy * _GrainOffsetScale.zw + _GrainOffsetScale.xy;
	o.uvs = v.texcoord.xy * _ScratchOffsetScale.zw + _ScratchOffsetScale.xy;
	return o;
}

half4 frag (v2f i) : COLOR
{
	half4 col = texRECT(_MainTex, i.uv);
	
	// convert to YUV
	half3 yuv;
	yuv.x = dot( col.rgb, half3(0.299,0.587,0.114) );
	yuv.y = (col.b-yuv.x)*0.492;
	yuv.z = (col.r-yuv.x)*0.877;
	
	// sample noise texture and do a signed add
	half3 grain = tex2D(_GrainTex, i.uvg).rgb * 2 - 1;
	yuv.rgb += grain * _Intensity.x;

	// convert back to rgb
	col.r = yuv.z * 1.140 + yuv.x;
	col.g = yuv.z * (-0.581) + yuv.y * (-0.395) + yuv.x;
	col.b = yuv.y * 2.032 + yuv.x;

	// sample scratch texture and add
	half3 scratch = tex2D(_ScratchTex, i.uvs).rgb * 2 - 1;
	col.rgb += scratch * _Intensity.y;

	return col;
}
ENDCG
	}
}

Fallback off

}